/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.integration.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.resource.cooking.IBurningRecipe;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class BurningRecipeCategory<R extends IRecipe<?> & IBurningRecipe>
implements IRecipeCategory<R> {
    private static final ResourceLocation RECIPE_GUI_VANILLA = new ResourceLocation("jei", "textures/gui/gui_vanilla.png");
    private static final int INPUT = 0;
    private static final int OUTPUT = 2;
    private final ResourceLocation categoryId;
    private final IDrawableAnimated flameAnimated;
    private final IDrawable background;
    private final IDrawable icon;
    private final String title;
    private final int regularCookTime;
    private final Class<R> recipeClass;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public BurningRecipeCategory(final IGuiHelper helper, String category, Block iconBlock, int regularCookTime, Class<R> recipeClass) {
        this.categoryId = GunsRPG.makeResource(category);
        this.title = category.substring(0, 1).toUpperCase() + category.substring(1);
        IDrawableStatic flameStatic = helper.createDrawable(RECIPE_GUI_VANILLA, 82, 114, 14, 14);
        this.flameAnimated = helper.createAnimatedDrawable(flameStatic, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.background = helper.createDrawable(RECIPE_GUI_VANILLA, 0, 114, 82, 54);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)iconBlock));
        this.regularCookTime = regularCookTime;
        this.recipeClass = recipeClass;
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return helper.drawableBuilder(RECIPE_GUI_VANILLA, 82, 128, 24, 17).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public ResourceLocation getUid() {
        return this.categoryId;
    }

    public Class<R> getRecipeClass() {
        return this.recipeClass;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }

    public void setIngredients(R recipe, IIngredients ingredients) {
        ItemStack[] stacks = ((IBurningRecipe)recipe).getInputStacks();
        ingredients.setInputs(VanillaTypes.ITEM, Arrays.asList(stacks));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void draw(R recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.flameAnimated.draw(matrixStack, 1, 20);
        IDrawableAnimated arrow = this.getArrow(recipe);
        arrow.draw(matrixStack, 24, 18);
        this.drawExperience(recipe, matrixStack, 0);
        this.drawCookTime(recipe, matrixStack, 45);
    }

    public void setRecipe(IRecipeLayout recipeLayout, R recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(2, false, 60, 18);
        guiItemStacks.set(ingredients);
    }

    private void drawExperience(R recipe, MatrixStack matrixStack, int y) {
        float experience = ((IBurningRecipe)recipe).getExperience();
        if (experience > 0.0f) {
            TranslationTextComponent experienceString = new TranslationTextComponent("gui.jei.category.smelting.experience", new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontRenderer = minecraft.field_71466_p;
            int stringWidth = fontRenderer.func_238414_a_((ITextProperties)experienceString);
            fontRenderer.func_243248_b(matrixStack, (ITextComponent)experienceString, (float)(this.background.getWidth() - stringWidth), (float)y, -8355712);
        }
    }

    private void drawCookTime(R recipe, MatrixStack matrixStack, int y) {
        int cookTime = ((IBurningRecipe)recipe).getCookTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            TranslationTextComponent timeString = new TranslationTextComponent("gui.jei.category.smelting.time.seconds", new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontRenderer = minecraft.field_71466_p;
            int stringWidth = fontRenderer.func_238414_a_((ITextProperties)timeString);
            fontRenderer.func_243248_b(matrixStack, (ITextComponent)timeString, (float)(this.background.getWidth() - stringWidth), (float)y, -8355712);
        }
    }

    private IDrawableAnimated getArrow(R recipe) {
        int cookTime = ((IBurningRecipe)recipe).getCookTime();
        if (cookTime <= 0) {
            cookTime = this.regularCookTime;
        }
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)cookTime);
    }
}

